function[Ypred,actual,errors] = kNN(data,pset,p,method)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Exercise 9.2(a)+(b)
% File: kNN.m
%
% Converted from GAUSS routines (supplementary material) written by 
% Ted Jaditz and Leigh A. Riddick. 
% 
% Reference:
% Jaditz, T. and Riddick, L.A. (2000).
%   Time-Series Near-Neighbor Regression.
%   Studies in Nonlinear Dynamics and Econometrics, 
%   4(1), 35-44.
%   DOI: 10.2202/1558-3708.1054.
%
% INPUT:
% data   = Vector of T=size(data,1) time series Y_{t} 
% pset   = Size of the prediction set 
%          P = {(Y_{t},X_{t}): N_{f}<t<= T}
% p      = 1,2. Dimension of X_{t}=(Y_{t},Y_{t+1},...,Y_{t+p-1})'
% method = type of "fitting" (window) set F: 
%          1 = Fixed, i.e. F={(Y_{t},X_{t}): t<=N_{f}}
%          2 = Rolling, i.e. F_{t}={(Y_{i},X_{i}): t-N_{f}<i<t}
%          3 = Expanding, i.e. F_{t}={(Y_{i},X_{i}): i<t}
% 
% OUTPUT:
% Ypred  = One-step ahead forecasts for the value of k 
%          that minimizes the CV estimate of MSE
% actual = Actual values
% error  = Prediction error  (= actual - Ypred)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if p == 1;
   x1 = data(p:size(data,1));
   X  = x1;
elseif p == 2;
   x1 = data(p:size(data,1)-1);            
   x2 = data(p-1:size(data,1)-2);
   X  = [x1,x2];
end
y = data(p+1:size(data,1));
for i = 1:pset;  % Start main loop, for each observation in F_{t} 
    yi = y(size(y,1)-pset+i);
    xi = X(size(X,1)-pset+i,:);
    if  method == 1;
        ypred = y(1:size(y,1)-pset);
        xpred = X(1:size(X,1)-pset,:);
    elseif method == 2;
        ypred = y(i:size(y,1)-pset+i-1);
        xpred = X(i:size(X,1)-pset+i-1,:);
    elseif method == 3;
        ypred = y(1:size(y,1)-pset+i-1);
        xpred = X(1:size(X,1)-pset+i-1,:);
    end
%   Create distance table 
    distance = zeros(size(xpred,1),1);
    for j = 1:size(xpred,1);
        distance(j) = max(abs(xpred(j,:)'-xi')); % supremum norm
    end
%   Sort the data according to distance 
    datasort       = sortrows([distance,ypred,xpred]);    
    sortedDistance = datasort(:,1);
    ypred          = datasort(:,2);
    xpred = datasort(:,3:size(datasort,2));
%   Loop through sorted data doing regressions 
    XX = zeros(size(xpred,2),size(xpred,2));
    Xy = zeros(size(X,2),1);
    msekNN  = zeros(size(xpred,1),1);      
    for j = 1:size(xpred,1); 
%       Update matrices for this regression ... 
        XX = XX+xpred(j,:)'*xpred(j,:);
        Xy = Xy+xpred(j,:)'*ypred(j);
%       Solve for the parameter vector ... 
        XXinv = pinv(XX); % Moore-Penrose pseudoinverse     
        bij   = XXinv*Xy;
        eij   = yi-xi*bij;
        if j == 1 ; 
           eij = yi-ypred(1); 
        end
        msekNN(j) = msekNN(j)+eij*eij;
    end  % end of loop over neighbors, j=1:size(xpred,1)    
end      % end of loop over elements of the P set, i=1:pset         
%   Identify, rebuild the best near-neighbor 
    [C,whichOne] = min(msekNN/pset);
    fprintf('Min. MSE occurs at %d where MSE = %d.\n',whichOne,C);
    actual = y(size(y,1)-pset+1:size(y,1));
%   Start rebuilding the k-NN forecasts
for i = 1:pset
    yiRe = y(size(y,1)-pset +i);
    xiRe = X(size(X,1)-pset+i,:);
    if method == 1;
       ypredRe = y(1:size(y,1)-pset);
       xpredRe = X(1:size(X,1)-pset,:);
    elseif method == 2;
       ypredRe = y(i:size(y,1)-pset+i-1);
       xpredRe = X(i:size(X,1)-pset+i-1,:);
    elseif method == 3;
       ypredRe = y(1:size(y,1)-pset+i-1);
       xpredRe = X(1:size(X,1)-pset+i-1,:);
    end    
%   Create distance table 
    distanceRe = zeros(size(xpredRe,1),1);
    for j = 1:size(xpredRe,1);
        distanceRe(j) = max(abs(xpredRe(j,:)'-xiRe'));
    end
%   Sort the data according to distance 
    dataRe  = sortrows([distanceRe,ypredRe,xpredRe]);   
    ypredRe = dataRe(:,2);    
    xpredRe = dataRe(:,3:size(dataRe,2));   
%   Build the data set to replicate the regression 
    XXRe = zeros(size(xpredRe,2),size(xpredRe,2));
    XyRe = zeros(size(X,2),1);    
    for j = 1:whichOne; 
        XXRe = XXRe+xpredRe(j,:)'*xpredRe(j,:);
        XyRe = XyRe+xpredRe(j,:)'*ypredRe(j);
    end    
    XXinvRe  = pinv(XXRe);
    bijRe    = XXinvRe*XyRe;
    eijRe    = yiRe-xiRe*bijRe;
    error(i) = eijRe;
end  % end of loop over elements of P set, i=1:pset    
    Ypred    = actual-error';
end